-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/

CREATE DATABASE IF NOT EXISTS `hgzy_game` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE `hgzy_game`;

-- --------------------------------------------------------

-- টেবিল: users
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` varchar(50) NOT NULL,
  `name` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `password` varchar(255) NOT NULL,
  `uiId` bigint(20) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `depositBalance` decimal(12,2) DEFAULT 0.00,
  `winningBalance` decimal(12,2) DEFAULT 0.00,
  `totalBetAmount` decimal(12,2) DEFAULT 0.00,
  `hasDeposited` tinyint(1) DEFAULT 0,
  `referrer` bigint(20) DEFAULT NULL,
  `turnoverReq` decimal(12,2) DEFAULT 0.00,
  `totalCommission` decimal(12,2) DEFAULT 0.00,
  `directSubs` int(11) DEFAULT 0,
  `teamSubs` int(11) DEFAULT 0,
  `vipLevel` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `phone` (`phone`),
  UNIQUE KEY `uiId` (`uiId`),
  UNIQUE KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: deposits
CREATE TABLE `deposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `uid` varchar(50) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `method` varchar(20) NOT NULL,
  `transactionId` varchar(100) NOT NULL,
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  `admin_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `processed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `uid` (`uid`),
  CONSTRAINT `deposits_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: withdrawals
CREATE TABLE `withdrawals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `uid` varchar(50) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `method` varchar(20) NOT NULL,
  `wallet_number` varchar(20) NOT NULL,
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  `admin_notes` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `processed_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `uid` (`uid`),
  CONSTRAINT `withdrawals_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: bets
CREATE TABLE `bets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `uid` varchar(50) NOT NULL,
  `game_type` varchar(20) NOT NULL,
  `period` varchar(50) NOT NULL,
  `bet_type` varchar(20) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `potential_win` decimal(10,2) DEFAULT NULL,
  `outcome` enum('pending','win','lose') DEFAULT 'pending',
  `win_amount` decimal(10,2) DEFAULT 0.00,
  `result_number` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `settled_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `uid` (`uid`),
  KEY `game_type` (`game_type`),
  KEY `period` (`period`),
  CONSTRAINT `bets_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: commissions
CREATE TABLE `commissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `from_user_id` int(11) NOT NULL,
  `type` varchar(50) NOT NULL COMMENT 'Bet Comm, Referral, etc',
  `amount` decimal(10,2) NOT NULL,
  `description` text DEFAULT NULL,
  `bet_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `from_user_id` (`from_user_id`),
  CONSTRAINT `commissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `commissions_ibfk_2` FOREIGN KEY (`from_user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: transactions
CREATE TABLE `transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `type` enum('deposit','withdrawal','bet','win','commission','bonus') NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `balance_before` decimal(12,2) NOT NULL,
  `balance_after` decimal(12,2) NOT NULL,
  `reference_id` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `transactions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: game_history
CREATE TABLE `game_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `game_type` varchar(20) NOT NULL,
  `period` varchar(50) NOT NULL,
  `result_number` int(11) NOT NULL,
  `result_color` varchar(20) DEFAULT NULL,
  `result_size` varchar(10) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `game_period` (`game_type`,`period`),
  KEY `game_type` (`game_type`),
  KEY `period` (`period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: vip_levels
CREATE TABLE `vip_levels` (
  `level` int(11) NOT NULL,
  `min_bet` decimal(12,2) NOT NULL,
  `monthly_salary` decimal(10,2) NOT NULL,
  `commission_rate` decimal(5,4) DEFAULT 0.0060,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- VIP লেভেল ডাটা ইনসার্ট
INSERT INTO `vip_levels` (`level`, `min_bet`, `monthly_salary`, `commission_rate`) VALUES
(0, 0.00, 0.00, 0.0060),
(1, 5000.00, 50.00, 0.0065),
(2, 50000.00, 200.00, 0.0070),
(3, 200000.00, 1000.00, 0.0075),
(4, 500000.00, 3000.00, 0.0080),
(5, 1000000.00, 7000.00, 0.0085),
(6, 3000000.00, 20000.00, 0.0090),
(7, 8000000.00, 50000.00, 0.0095),
(8, 20000000.00, 150000.00, 0.0100),
(9, 50000000.00, 400000.00, 0.0105),
(10, 100000000.00, 1000000.00, 0.0110);

-- --------------------------------------------------------

-- টেবিল: sessions
CREATE TABLE `sessions` (
  `id` varchar(128) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` text NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `sessions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

-- টেবিল: settings
CREATE TABLE `settings` (
  `key` varchar(100) NOT NULL,
  `value` text DEFAULT NULL,
  `type` varchar(20) DEFAULT 'text',
  `description` text DEFAULT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- সেটিংস ডাটা ইনসার্ট
INSERT INTO `settings` (`key`, `value`, `type`, `description`) VALUES
('agent_bkash', '01700000001', 'text', 'bKash Agent Number'),
('agent_nagad', '01800000002', 'text', 'Nagad Agent Number'),
('agent_rocket', '01900000003', 'text', 'Rocket Agent Number'),
('min_deposit', '100', 'number', 'Minimum Deposit Amount'),
('min_withdraw', '200', 'number', 'Minimum Withdrawal Amount'),
('max_withdraw', '50000', 'number', 'Maximum Withdrawal Amount'),
('commission_rate', '0.006', 'number', 'Commission Rate (0.6%)'),
('site_name', 'HGZY GAME', 'text', 'Website Name'),
('maintenance', '0', 'boolean', 'Maintenance Mode'),
('withdrawal_fee', '0', 'number', 'Withdrawal Fee Percentage');